/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowMapPane;
import filenet.vw.toolkit.utils.mapui.VWMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;

public class VWMapCache {
    private HashMap m_currentMapCache = new HashMap();
    private HashMap m_baseMapCache = new HashMap();

    public void reset() {
        this.clear(this.m_currentMapCache);
        this.clear(this.m_baseMapCache);
    }

    public void addCurrentMap(VWMap map) {
        if (map != null) {
            this.m_currentMapCache.put(map.getName(), map);
        }
    }

    public void addBaseMap(VWMap map) {
        if (map != null) {
            this.m_baseMapCache.put(map.getName(), map);
        }
    }

    public VWMap get(String mapName, boolean checkForBaseMap) {
        VWMap map = null;
        if (mapName != null && mapName.length() > 0) {
            map = (VWMap)this.m_currentMapCache.get(mapName);
        }
        if (map == null && checkForBaseMap) {
            map = this.getBaseMap(mapName);
        }
        return map;
    }

    public VWMap getBaseMap(String mapName) {
        VWMap map = null;
        if (mapName != null && mapName.length() > 0) {
            map = (VWMap)this.m_baseMapCache.get(mapName);
        }
        return map;
    }

    public boolean isMapExist(String mapName, boolean includeBaseMap) {
        return mapName != null && mapName.length() > 0 && this.get(mapName, includeBaseMap) != null;
    }

    public boolean isBaseMapExist(String mapName) {
        return mapName != null && mapName.length() > 0 && this.getBaseMap(mapName) != null;
    }

    public boolean remove(String mapName) {
        VWMap map;
        if (mapName != null && mapName.length() > 0 && (map = (VWMap)this.m_currentMapCache.remove(mapName)) != null) {
            map.removeReferences();
            return true;
        }
        return false;
    }

    public void rename(String oldMapName, String newMapName) {
        try {
            VWMap map;
            if (oldMapName != null && oldMapName.length() > 0 && newMapName != null && newMapName.length() > 0 && (map = (VWMap)this.m_currentMapCache.remove(oldMapName)) != null) {
                VWMapDefinition mapDef = map.getMapDefinition();
                mapDef.setName(newMapName);
                this.addCurrentMap(map);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWMapDefinition getMapDefinition(String mapName) {
        VWMap map;
        VWMapDefinition mapDef = null;
        if (mapName != null && mapName.length() > 0 && (map = this.get(mapName, true)) != null) {
            mapDef = map.getMapDefinition();
        }
        return mapDef;
    }

    public VWMapDefinition[] getMapDefinitions() {
        VWMapDefinition[] mapDefs = null;
        VWMap[] maps = this.toArray();
        if (maps != null) {
            int nCount = this.size();
            mapDefs = new VWMapDefinition[nCount];
            for (int i = 0; i < nCount; ++i) {
                mapDefs[i] = maps[i].getMapDefinition();
            }
        }
        return mapDefs;
    }

    public VWMapDefinition[] getCurrentMapDefinitions() {
        VWMap[] maps = null;
        VWMapDefinition[] mapDefs = null;
        ArrayList array = new ArrayList(this.m_currentMapCache.values());
        if (array != null) {
            maps = new VWMap[array.size()];
            array.toArray(maps);
        }
        if (maps != null) {
            mapDefs = new VWMapDefinition[maps.length];
            for (int i = 0; i < maps.length; ++i) {
                mapDefs[i] = maps[i].getMapDefinition();
            }
        }
        return mapDefs;
    }

    public VWMapDefinition[] getBaseMapDefinitions() {
        VWMap[] maps = null;
        VWMapDefinition[] mapDefs = null;
        ArrayList array = new ArrayList(this.m_baseMapCache.values());
        if (array != null) {
            maps = new VWMap[array.size()];
            array.toArray(maps);
        }
        if (maps != null) {
            mapDefs = new VWMapDefinition[maps.length];
            for (int i = 0; i < maps.length; ++i) {
                mapDefs[i] = maps[i].getMapDefinition();
            }
        }
        return mapDefs;
    }

    public VWBaseWorkflowMapPane getMapPane(String mapName) {
        VWMap map;
        VWBaseWorkflowMapPane mapPane = null;
        if (mapName != null && mapName.length() > 0 && (map = this.get(mapName, true)) != null) {
            mapPane = map.getMapPane();
        }
        return mapPane;
    }

    public VWBaseWorkflowMapPane[] getMapPanes() {
        int nCount;
        VWBaseWorkflowMapPane[] mapPanes = null;
        VWMap[] maps = this.toArray();
        if (maps != null && (nCount = this.size()) > 0) {
            mapPanes = new VWBaseWorkflowMapPane[nCount];
            for (int i = 0; i < nCount; ++i) {
                mapPanes[i] = maps[i].getMapPane();
            }
        }
        return mapPanes;
    }

    public VWMap[] toArray() {
        VWMap[] maps = null;
        ArrayList array = this.toArrayList(true);
        if (array != null) {
            maps = new VWMap[this.size()];
            array.toArray(maps);
        }
        return maps;
    }

    public VWMap[] toArray(boolean allMaps) {
        VWMap[] maps = null;
        ArrayList array = this.toArrayList(allMaps);
        if (array != null) {
            maps = new VWMap[this.size()];
            array.toArray(maps);
        }
        return maps;
    }

    public Vector toVector() {
        Vector<VWMap> vector = null;
        VWMap[] maps = this.toArray();
        if (maps != null) {
            vector = new Vector<VWMap>();
            for (int i = 0; i < this.size(); ++i) {
                vector.addElement(maps[i]);
            }
        }
        return vector;
    }

    public int allSize() {
        return this.currentSize() + this.baseSize();
    }

    public int currentSize() {
        return this.m_currentMapCache.size();
    }

    public int size() {
        return this.toArrayList(true).size();
    }

    public int baseSize() {
        return this.m_baseMapCache.size();
    }

    public String[] getMapNames() {
        int count;
        String[] names = null;
        VWMapDefinition[] mapDefs = this.getMapDefinitions();
        if (mapDefs != null && (count = mapDefs.length) > 0) {
            names = new String[count];
            for (int i = 0; i < count; ++i) {
                names[i] = mapDefs[i].getName();
            }
        }
        return names;
    }

    public boolean isEditable(String mapName) {
        boolean editable = false;
        if (mapName != null && mapName.length() > 0) {
            editable = this.get(mapName, false) != null;
        }
        return editable;
    }

    private ArrayList toArrayList(boolean allMaps) {
        ArrayList array = null;
        if (this.allSize() > 0) {
            Collection mapCollection = this.m_currentMapCache.values();
            Collection baseMapCollection = this.m_baseMapCache.values();
            array = new ArrayList(mapCollection);
            if (allMaps) {
                ArrayList baseMapArray = new ArrayList(baseMapCollection);
                for (int i = 0; i < this.baseSize(); ++i) {
                    String mapName;
                    VWMap map = (VWMap)baseMapArray.get(i);
                    if (map == null || this.isMapExist(mapName = map.getName(), false)) continue;
                    array.add(map);
                }
            }
        }
        return array;
    }

    private void clear(HashMap hashMap) {
        if (hashMap != null && !hashMap.isEmpty()) {
            Collection mapCollection = hashMap.values();
            if (mapCollection != null && !mapCollection.isEmpty()) {
                VWMap[] maps = new VWMap[mapCollection.size()];
                mapCollection.toArray(maps);
                for (int i = 0; i < maps.length; ++i) {
                    maps[i].removeReferences();
                }
            }
            hashMap.clear();
        }
    }
}

